#include "wm_include.h"
#include <string.h>
#include "wm_pwm.h"
#include "wm_cpu.h"
#include "wm_io.h"
#include "wm_demo.h"
#include "wm_regs.h"
#include "wm_dma.h"
#include "random.h"
#include "wm_gpio_afsel.h"

#define TASK_SIZE  256
static OS_STK breathing_lamp_task_stk[TASK_SIZE]; 

#define DUTY_MAX   250
#define DUTY_MIN   1

/* 0-ԭɫͬɰɫ, 1-ԭɫɫ𽥱任 */
#define USE_THREE_COLOR_TRANSFORMATIONS     0

/* 
    GPIOĸùܣʹ临ΪPWMܣ
*/
static int pwm_demo_multiplex_config(u8 channel)
{

	switch (channel)
	{
		case 0:
			wm_pwm1_config(WM_IO_PB_18);
		case 1:
			wm_pwm2_config(WM_IO_PB_17);
		case 2:
			wm_pwm3_config(WM_IO_PB_16);
		case 3:
			wm_pwm4_config(WM_IO_PB_15);
		case 4:
			wm_pwm5_config(WM_IO_PB_14);
		default:
			return -1;
	}
}

/* 
    5·PWMΪͬģʽͨ1ͨ4ͨ0һ£
*/
static int pwm_demo_allsyc_mode(u8 channel,u32 freq, u8 duty, u8 num)
{
    pwm_init_param pwm_param;
    int ret=-1;
	tls_sys_clk sysclk;
	
	tls_sys_clk_get(&sysclk);

    memset(&pwm_param, 0, sizeof(pwm_init_param));
    pwm_param.period = 255;
    pwm_param.cnt_type = WM_PWM_CNT_TYPE_EDGE_ALIGN_OUT;
    pwm_param.loop_type = WM_PWM_LOOP_TYPE_LOOP;
    pwm_param.mode = WM_PWM_OUT_MODE_ALLSYC;
    pwm_param.inverse_en = DISABLE;
    pwm_param.pnum = num;
    pwm_param.pnum_int = DISABLE;
    pwm_param.duty = duty;
    pwm_param.channel = channel;
    pwm_param.clkdiv = sysclk.apbclk*UNIT_MHZ/256/freq;

    ret = tls_pwm_out_init(pwm_param);

    return ret;
}

/* 
    2·PWMΪͬģʽͨ1ͨ0һ£ ͨ3ͨ2һ£
*/
static int pwm_demo_2syc_mode(u8 channel,u32 freq, u8 duty, u8 num)
{
    pwm_init_param pwm_param;
    int ret=-1;
	tls_sys_clk sysclk;
	
	tls_sys_clk_get(&sysclk);

    memset(&pwm_param, 0, sizeof(pwm_init_param));
    pwm_param.period = 255;
    pwm_param.cnt_type = WM_PWM_CNT_TYPE_EDGE_ALIGN_OUT;
    pwm_param.loop_type = WM_PWM_LOOP_TYPE_LOOP;
    pwm_param.mode = WM_PWM_OUT_MODE_2SYC;
    pwm_param.inverse_en = DISABLE;
    pwm_param.pnum = num;
    pwm_param.pnum_int = DISABLE;
    pwm_param.duty = duty;
    pwm_param.channel = channel;
    pwm_param.clkdiv = sysclk.apbclk*UNIT_MHZ/256/freq;

    ret = tls_pwm_out_init(pwm_param);

    return ret;
}

/* 
    2·PWMΪģʽͨ1ͨ0 ͨ3ͨ2
*/
static int pwm_demo_mc_mode(u8 channel,u32 freq, u8 duty, u8 num)
{
    pwm_init_param pwm_param;
    int ret=-1;
	tls_sys_clk sysclk;
	
	tls_sys_clk_get(&sysclk);

    memset(&pwm_param, 0, sizeof(pwm_init_param));
    pwm_param.period = 255;
    pwm_param.cnt_type = WM_PWM_CNT_TYPE_EDGE_ALIGN_OUT;
    pwm_param.loop_type = WM_PWM_LOOP_TYPE_LOOP;
    pwm_param.mode = WM_PWM_OUT_MODE_MC;
    pwm_param.inverse_en = DISABLE;
    pwm_param.pnum = num;
    pwm_param.pnum_int = DISABLE;
    pwm_param.duty = duty;
    pwm_param.channel = channel;
    pwm_param.clkdiv = sysclk.apbclk*UNIT_MHZ/256/freq;
    
    pwm_param.dten = ENABLE;
    pwm_param.dtclkdiv = 3;
    pwm_param.dtcnt = 255;

    ret = tls_pwm_out_init(pwm_param);

    return ret;
}

/* 
    PWMΪƶģʽ˴ǿߵƽ
*/
static int pwm_demo_break_mode(u8 channel,u32 freq, u8 duty)
{
    int ret=-1;
    
    ret = tls_pwm_brake_mode_config(channel, ENABLE, WM_PWM_BRAKE_OUT_HIGH);

    return ret;
}


/**
 * @brief          This function is used demonstrate pwm usage.
 *
 * @param[in]       channel    pwm channel, range from 0 to 4
 * @param[in]       freq       freq range from 3Hz~160kHz
 * @param[in]       duty       duty range from 0 to 255
 * @param[in]       mode       0:BRAKE, 1:ALLSYC, 2:2SYC, 3:MC, 4:INDPT
 * @param[in]       pnum       period num,range from 0 to 255
 *
 * @retval         WM_SUCCESS success
 * @retval         WM_FAILED  failed
 *
 * @note           For example, call this like this "pwm_demo(0,20,99,1,0);".
 */
static int pwm_demo_start(u8 channel, u16 freq, u8 duty, u8 mode, u8 num)
{
    int  ret=-1;

    if(channel < 5)
    {
        pwm_demo_multiplex_config(channel);
        tls_pwm_stop(channel);
    }
    else
    {
        return WM_FAILED;
    }
    
    switch (mode)
    {
        case WM_PWM_OUT_MODE_INDPT:
            /* ģʽ */
            ret = tls_pwm_init(channel, freq, duty, num);
            if(ret != WM_SUCCESS)
                return ret;
            tls_pwm_start(channel);
            break;
            
        case WM_PWM_OUT_MODE_ALLSYC:
            /* ȫͨͬģʽchannel 1-channel4channel0һ  */
            ret = pwm_demo_allsyc_mode(channel, freq, duty, num);
            if(ret != WM_SUCCESS)
                return ret;
            tls_pwm_start(channel);
            break;
            
        case WM_PWM_OUT_MODE_2SYC:
             /* ˫ͨͬģʽ  */
            ret = pwm_demo_2syc_mode(channel, freq, duty, num);
            if(ret != WM_SUCCESS)
                return ret;
            tls_pwm_start(channel);
            break;
            
        case WM_PWM_OUT_MODE_MC:
            /* ˫ͨģʽ  */
            ret = pwm_demo_mc_mode(channel, freq, duty, num);
            if(ret != WM_SUCCESS)
                return ret;
            tls_pwm_start(channel);
            break;
            
        case WM_PWM_OUT_MODE_BRAKE:
            /* ƶģʽ  */
            ret = pwm_demo_break_mode(channel, freq, duty);
            if(ret != WM_SUCCESS)
                return ret;
            tls_pwm_start(channel);
            break;
            
        default:
            break;
    }
	return WM_SUCCESS;
}

static void breathing_lamp_task(void *sdata)
{
#if USE_THREE_COLOR_TRANSFORMATIONS
    u8  channel = 0;
    u16 duty_red = DUTY_MIN;
    u8  red_reverse = 0;
    u16 duty_green = (DUTY_MAX - DUTY_MIN) / 2;
    u8  green_reverse = 0;
    u16 duty_blue = DUTY_MAX;
    u8  blue_reverse = 0;

    pwm_demo_start(0, 100, duty_blue, 4, 0);
    pwm_demo_start(1, 100, duty_green, 4, 0);
    pwm_demo_start(2, 100, duty_red, 4, 0);

    while (1)
    {
        switch (channel)
        {
            case 0:
            {
                if (blue_reverse)
                {
                    duty_blue--;
                    if (duty_blue < DUTY_MIN)
                    {
                        blue_reverse = 0;
                        duty_blue = DUTY_MIN;
                    }
                }
                else
                {
                    duty_blue++;
                    if (duty_blue > DUTY_MAX)
                    {
                        blue_reverse = 1;
                        duty_blue = DUTY_MAX;
                    }
                }

                tls_pwm_duty_set(channel, duty_blue);
                break;
            }
            case 1:
            {
                if (green_reverse)
                {
                    duty_green--;
                    if (duty_green < DUTY_MIN)
                    {
                        green_reverse = 0;
                        duty_green = DUTY_MIN;
                    }
                }
                else
                {
                    duty_green++;
                    if (duty_green > DUTY_MAX)
                    {
                        green_reverse = 1;
                        duty_green = DUTY_MAX;
                    }
                }

                tls_pwm_duty_set(channel, duty_green);
                break;
            }
            case 2:
            {
                if (red_reverse)
                {
                    duty_red--;
                    if (duty_red < DUTY_MIN)
                    {
                        red_reverse = 0;
                        duty_red = DUTY_MIN;
                    }
                }
                else
                {
                    duty_red++;
                    if (duty_red > DUTY_MAX)
                    {
                        red_reverse = 1;
                        duty_red = DUTY_MAX;
                    }
                }

                tls_pwm_duty_set(channel, duty_red);
                break;
            }
            default:
            {
                break;
            }
        }

        //printf("channel: %hhu, red duty: %hhu, green duty: %hhu, blue duty: %hhu\n", channel, duty_red, duty_green, duty_blue);

        if (++channel > 2) channel = 0;

        tls_os_time_delay(1);
    }

#else /* USE_THREE_COLOR_TRANSFORMATIONS */

    u16 duty = DUTY_MIN;
    u8  reverse = 0;

    pwm_demo_start(0, 100, duty, 4, 0);
    pwm_demo_start(1, 100, duty, 4, 0);
    pwm_demo_start(2, 100, duty, 4, 0);

    while (1)
    {
        if (reverse)
        {
            duty--;
            if (duty < DUTY_MIN)
            {
                reverse = 0;
                duty = DUTY_MIN;
            }
        }
        else
        {
            duty++;
            if (duty > DUTY_MAX)
            {
                reverse = 1;
                duty = DUTY_MAX;
            }
        }

        tls_pwm_duty_set(0, duty);
        tls_pwm_duty_set(1, duty);
        tls_pwm_duty_set(2, duty);

        //printf("duty: %hhu\n", duty);

        tls_os_time_delay(3);
    }
#endif /* USE_THREE_COLOR_TRANSFORMATIONS */
}

void UserMain(void)
{
    printf("\n w600 pwm breathing lamp\n");

    tls_os_task_create(NULL, NULL,
                       breathing_lamp_task,
                       NULL,
                       (void *)breathing_lamp_task_stk,
                       TASK_SIZE * sizeof(u32),
                       32,
                       0);
}


